local self_ID = "1903 Wright Flyer FM by Aero"
--EFM Sources:
--https://core.ac.uk/download/pdf/4887129.pdf
--http://www2.coe.pku.edu.cn/tpic/file/20160115/20160115230499799979.pdf
--https://www.liverpool.ac.uk/media/livacuk/flightscience/projects/fs/fshistory/wright/publications/SFTE_PAPER_FINAL.pdf

declare_plugin(self_ID,
{
image     	 = "Flyer1.bmp",
installed 	 = true,
dirName	  	 = current_mod_path,
developerName = _("Grinnelli-Aero"),
fileMenuName = _("Flyer1"),
displayName  = _("Flyer1"),
shortName	=   "Flyer1",
version		 = "Prototype",	 
state		 = "installed",
encyclopedia_path = current_mod_path..'/Encyclopedia',
info		 = _("GrinnelliDesigns presents:Community 1903 Wright Flyer | Flight Model developed by Aero"),
----------------------------------------------------------------------------------------
binaries 	 =
{
'Flyer1',
},
Skins	=
	{
		{
			name	= _("Flyer1"),
			dir		= "Theme"
		},
	},
Missions =
{
	{
		name		    = _("Flyer1"),
		dir			    = "Missions",
	},
},
LogBook =
	{
		{
			name		= _("Flyer1"),
			type		= "Flyer1",
		},
	},	
InputProfiles =
	{
		["Flyer1"]     = current_mod_path .. '/Input/Flyer1',
	},
		
	
	
})
----------------------------------------------------------------------------------------
mount_vfs_model_path    (current_mod_path.."/Shapes")
mount_vfs_liveries_path (current_mod_path.."/Liveries")
mount_vfs_texture_path  (current_mod_path.."/Textures")
mount_vfs_texture_path  (current_mod_path.."/Textures/Flyer1.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/Customize")
mount_vfs_model_path    (current_mod_path.."/Cockpit/Shape") 
--mount_vfs_sound_path    (current_mod_path.."/Sounds")
mount_vfs_texture_path  (current_mod_path .."/Theme")
----------------------------------------------------------------------------------------

local rear_amortizer_static_force = 2200 -- 315
local rear_amortizer_direct_damper_force_factor = rear_amortizer_static_force * .3
local rear_amortizer_back_damper_force_factor = rear_amortizer_static_force * .3

local main_amortizer_static_force = 1500.0 -- 300
local main_amortizer_direct_damper_force_factor = main_amortizer_static_force * .3
local main_amortizer_back_damper_force_factor = main_amortizer_static_force * .3
 
local wheel_static_friction_factor_COMMON = 0.50
local wheel_side_friction_factor_COMMON = 0.50
local wheel_roll_friction_factor_COMMON = 0.14
local wheel_glide_friction_factor_COMMON = 0.40
local wheel_brake_moment_max_COMMON = 500.00
local wheel_radius_COMMON = 0.0527

suspension = 
{
	{
		mass  			 					    = 5,
		pos   			 					    =  {2.52,	-0.918,	0},
		moment_of_inertia					    = {1,1,1},
		anti_skid_installed                     = false,
		
		wheel_axle_offset                       = 0.0,
		damage_element	   						= 83,
		damage_omega	   						= 30.0,
		self_attitude	   						= false,
		yaw_limit		   						= math.rad(20.0),
		damper_coeff	   						= 800.0,
		

		amortizer_min_length					= 0,
		amortizer_max_length					= .087,
		amortizer_basic_length					= .087,
		amortizer_spring_force_factor			= 2e+04, -- 7554181
		amortizer_spring_force_factor_rate		= 3, --20.0,
		amortizer_static_force					= rear_amortizer_static_force,--2658.0,
		amortizer_reduce_length					= .087,
		amortizer_direct_damper_force_factor	= rear_amortizer_direct_damper_force_factor, -- 1326
		amortizer_back_damper_force_factor		= rear_amortizer_back_damper_force_factor, -- 1160.0


		wheel_radius				   			= wheel_radius_COMMON,
		wheel_static_friction_factor 			= wheel_static_friction_factor_COMMON,
		wheel_side_friction_factor   			= wheel_side_friction_factor_COMMON,
		wheel_roll_friction_factor   			= wheel_roll_friction_factor_COMMON,
		wheel_glide_friction_factor  		    = wheel_glide_friction_factor_COMMON,
		wheel_damage_force_factor     			= 250.0,--250.0,
		wheel_damage_speed			   			= 500.0,


		wheel_moment_of_inertia  			    = .01, -- .1 wheel moi as rotation body

		wheel_brake_moment_max 					= 0.0, -- maximum value of braking moment  , N*m 
		
		arg_post			  					= 0,
		arg_amortizer		  					= 16,
		arg_wheel_rotation    					= 76,
		arg_wheel_yaw		  					= 19,
		collision_shell_name  					= "WHEEL_F",
	},
	{
		mass  			  						= 20,
		pos   			  						= 	{ -1.125, -0.933, 0.697},
		moment_of_inertia 						= {1,1,1},
		anti_skid_installed                     = true,
		
		wheel_axle_offset                       = 0.0,
		damage_element	   						= 83,
		damage_omega	   						= 30.0,
		self_attitude	    					= false,
		yaw_limit		    					= 0,
		--damper_coeff	    					= 200.0,
		
	    amortizer_min_length			        = 0.0,
		amortizer_max_length					= 0.087,
		amortizer_basic_length					= 0.087,
		amortizer_spring_force_factor			= 4.0e+04,--283242132
		amortizer_spring_force_factor_rate		= 3, --20.0,
		amortizer_static_force					= main_amortizer_static_force, --5707 80000.0
		amortizer_reduce_length					= 0.087,
		amortizer_direct_damper_force_factor	= main_amortizer_direct_damper_force_factor, --6006
		amortizer_back_damper_force_factor		= main_amortizer_back_damper_force_factor, --5255


		wheel_radius				   			= wheel_radius_COMMON,
		wheel_static_friction_factor 			= wheel_static_friction_factor_COMMON,
		wheel_side_friction_factor   			= wheel_side_friction_factor_COMMON,
		wheel_roll_friction_factor   			= wheel_roll_friction_factor_COMMON,
		wheel_glide_friction_factor  		    = wheel_glide_friction_factor_COMMON,
		wheel_damage_force_factor     			= 250.0,--250.0,
		wheel_damage_speed			   			= 500.0,


		wheel_moment_of_inertia  			    = .1, --wheel moi as rotation body

		wheel_brake_moment_max 				    = wheel_brake_moment_max_COMMON, -- maximum value of braking moment  , N*m 
	
		arg_post			 					= 5,
		arg_amortizer		 					= 6,
		arg_wheel_rotation   					= 77,
		arg_wheel_yaw		 					= -1,
		collision_shell_name 					= "WHEEL_L",
	},
	{
		mass  			  						= 20,
		pos   			  						= 	{ -1.125, -0.933, -0.697},
		moment_of_inertia 						= {1,1,1},
		anti_skid_installed                     = true,
		
		wheel_axle_offset                       = 0.0,
		damage_element	   						= 83,
		damage_omega	   						= 30.0,
		self_attitude	    					= false,
		yaw_limit		    					= 0,
		--damper_coeff	    					= 200.0,
		

		amortizer_min_length					= 0.0,
		amortizer_max_length					= 0.087,
		amortizer_basic_length					= 0.087,
		amortizer_spring_force_factor			= 4.0e+04,--283242132
		amortizer_spring_force_factor_rate		= 3, --20.0,
		amortizer_static_force					= main_amortizer_static_force, --5707 80000.0
		amortizer_reduce_length					= 0.087,
		amortizer_direct_damper_force_factor	= main_amortizer_direct_damper_force_factor, --6006
		amortizer_back_damper_force_factor		= main_amortizer_back_damper_force_factor, --5255


		wheel_radius				   			= wheel_radius_COMMON,
		wheel_static_friction_factor 			= wheel_static_friction_factor_COMMON,
		wheel_side_friction_factor   			= wheel_side_friction_factor_COMMON,
		wheel_roll_friction_factor   			= wheel_roll_friction_factor_COMMON,
		wheel_glide_friction_factor  		    = wheel_glide_friction_factor_COMMON,
		wheel_damage_force_factor     			= 250.0,--250.0,
		wheel_damage_speed			   			= 500.0,

		wheel_moment_of_inertia  			    = .1, --wheel moi as rotation body

		wheel_brake_moment_max 				    = wheel_brake_moment_max_COMMON, -- maximum value of braking moment  , N*m 
		
		arg_post			  					= 3,
		arg_amortizer		  					= 4,
		arg_wheel_rotation    					= 77,
		arg_wheel_yaw		  					= -1,
		collision_shell_name  					= "WHEEL_R",
	},
}
----------------------------------------------------------------------------------------
local FM = {  self_ID, 
             'Flyer1' ,
			  old = false,
              center_of_mass = {0,0,0}, -- center of mass initial coordinates in coordinates of model 
              moment_of_inertia = {64.1724, 163.11, 30.868, 0},-- initial MOI values, long, normal, lat {600, 1305, 558}
				--{440, 905, 558}
              --config_path  = current_mod_path..'/Flyer1.lua', -- "path to file which you will use to configure you FM",
			  suspension   = suspension, -- gear posts initialization
}
----------------------------------------------------------------------------------------
dofile(current_mod_path..'/Flyer1.lua')
--dofile(current_mod_path.."/Views.lua")
----------------------------------------------------------------------------------------
make_view_settings('Flyer1', ViewSettings, SnapViews)
make_flyable('Flyer1',current_mod_path..'/Cockpit/Scripts/',FM,current_mod_path..'/comm.lua')
----------------------------------------------------------------------------------------
plugin_done()